/*
 * Decompiled with CFR 0.152.
 */
package com.main.Service;

import com.main.Service.ChitGroupServices;
import com.main.Service.PaymentServices;
import com.main.dao.ChitGroupDao;
import com.main.dao.ChitGroupMembersDao;
import com.main.dao.ChitsDao;
import com.main.dao.DividentDao;
import com.main.dto.ChitGroupDto;
import com.main.dto.ResponseDto;
import com.main.model.ChitGroupModel;
import com.main.model.ChitsModel;
import com.main.model.DividentModel;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChitGroupServicesImpl
implements ChitGroupServices {
    @Autowired
    ChitGroupDao chitGroupDao;
    @Autowired
    ChitsDao chitsDao;
    @Autowired
    ChitGroupMembersDao chitGroupMembersDao;
    @Autowired
    PaymentServices paymentServices;
    @Autowired
    DividentDao dividentDao;

    public ResponseDto add(ChitGroupDto chitGroupDto) throws Exception {
        try {
            if (chitGroupDto.getChitid() != null) {
                List dividents = this.dividentDao.getByChitid(chitGroupDto.getChitid());
                Boolean dividentedited = false;
                for (DividentModel divident : dividents) {
                    if (divident.getMonthlysubscription() != null && divident.getBidamount() != null) {
                        Double monthlysub = Double.parseDouble(divident.getMonthlysubscription());
                        Double bidamount = Double.parseDouble(divident.getBidamount());
                        if (monthlysub == 0.0) {
                            dividentedited = true;
                            break;
                        }
                        if (bidamount != 0.0) continue;
                        dividentedited = true;
                        break;
                    }
                    dividentedited = true;
                    break;
                }
                if (dividentedited.booleanValue()) {
                    ResponseDto response = new ResponseDto("Error", "Cannot create group if divident is not added", "Test");
                    return response;
                }
            } else {
                ResponseDto response = new ResponseDto("Error", "Chit Not found", "Test");
                return response;
            }
            ChitGroupModel model = new ChitGroupModel();
            model.setChitid(chitGroupDto.getChitid());
            model.setGroupnumber(chitGroupDto.getGroupnumber());
            String strDate = chitGroupDto.getStartdate().substring(0, chitGroupDto.getStartdate().indexOf("T"));
            String EndDate = chitGroupDto.getEnddate().substring(0, chitGroupDto.getEnddate().indexOf("T"));
            model.setStartdate(strDate);
            model.setEnddate(EndDate);
            model = this.chitGroupDao.save(model);
            List payments = this.paymentServices.getmonthforpaymentsave(model.getChitgroupid());
            ResponseDto response = new ResponseDto("Success", "Chit Group Added Successfully", "Test");
            return response;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<ChitGroupDto> getAll() {
        List group = this.chitGroupDao.getAll();
        ArrayList<ChitGroupDto> list = new ArrayList<ChitGroupDto>();
        group.stream().forEach(model -> list.add(this.ChitGroupDto_mapper(model)));
        return list;
    }

    public List<ChitGroupDto> getById(Long chitgroupid) {
        List group = this.chitGroupDao.getByIdList(chitgroupid);
        ArrayList<ChitGroupDto> list = new ArrayList<ChitGroupDto>();
        group.stream().forEach(model -> list.add(this.ChitGroupDto_mapper(model)));
        return list;
    }

    public ResponseDto edit(ChitGroupDto chitGroupDto) throws Exception {
        try {
            if (chitGroupDto.getChitgroupid() != null) {
                ChitGroupModel model = this.chitGroupDao.getById(chitGroupDto.getChitgroupid());
                model.setChitid(chitGroupDto.getChitid());
                model.setGroupnumber(chitGroupDto.getGroupnumber());
                model.setStartdate(chitGroupDto.getStartdate());
                model.setEnddate(chitGroupDto.getEnddate());
                model = this.chitGroupDao.save(model);
                ResponseDto response = new ResponseDto("Success", "Chit Group Edited Successfully", "Test");
                return response;
            }
            ResponseDto response = new ResponseDto("Error", "Chit Group Edit Failed", "Test");
            return response;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public ResponseDto delete(Long chitgroupid) {
        this.chitGroupDao.delete(chitgroupid);
        ResponseDto response = new ResponseDto("Success", "Chit Group Edited Successfully", "Test");
        return response;
    }

    public ChitGroupDto ChitGroupDto_mapper(ChitGroupModel model) {
        ChitGroupDto chitgroup = new ChitGroupDto();
        chitgroup.setChitgroupid(model.getChitgroupid());
        chitgroup.setChitid(model.getChitid());
        chitgroup.setGroupnumber(model.getGroupnumber());
        chitgroup.setStartdate(model.getStartdate());
        chitgroup.setEnddate(model.getEnddate());
        boolean present = this.chitsDao.existsById(model.getChitid());
        ChitsModel chit = this.chitsDao.getById(model.getChitid());
        chitgroup.setChitname(chit.getTitle());
        List totalmembers = this.chitGroupMembersDao.getByChitgroupidAndReplacedidIsNull(model.getChitgroupid());
        String memberTotal = totalmembers.size() + "/" + chit.getNumberofmembers();
        chitgroup.setCurrentmembers(memberTotal);
        return chitgroup;
    }

    public ChitGroupDto getgroupnumber(Long chitid) {
        List chitgroup = this.chitGroupDao.getbyChitid(chitid);
        int groupno = chitgroup.size() + 1;
        ChitGroupDto dto = new ChitGroupDto();
        dto.setGroupnumber(String.valueOf(groupno));
        return dto;
    }
}

