/*
 * Decompiled with CFR 0.152.
 */
package com.main.Service;

import com.main.Service.ChitsService;
import com.main.Service.DividentServices;
import com.main.Service.PaymentServices;
import com.main.dao.ChitGroupDao;
import com.main.dao.ChitGroupMembersDao;
import com.main.dao.ChitsDao;
import com.main.dao.GroupPaymentRecordDao;
import com.main.dao.PaymentsDao;
import com.main.dto.ChitsDto;
import com.main.dto.DividentDto;
import com.main.dto.MemberHeaderInfo;
import com.main.dto.PaymentDto;
import com.main.dto.ResponseDto;
import com.main.model.ChitGroupModel;
import com.main.model.ChitsModel;
import com.main.model.GroupPaymentRecordModel;
import com.main.model.PaymentsModel;
import com.main.response.PaymentHeaderResponse;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChitsServiceImpl
implements ChitsService {
    @Autowired
    ChitsDao chitsDao;
    @Autowired
    ChitGroupDao chitGroupDao;
    @Autowired
    PaymentsDao paymentsDao;
    @Autowired
    DividentServices dividentServices;
    @Autowired
    GroupPaymentRecordDao groupPaymentRecordDao;
    @Autowired
    ChitGroupMembersDao chitGroupMembersDao;
    @Autowired
    PaymentServices paymentServices;

    public ResponseDto add(ChitsDto chitsDto) throws Exception {
        try {
            if (chitsDto.getTotalmonths() != null) {
                ResponseDto response = new ResponseDto("Success", "Chit Added Successfully", "Test");
                ChitsModel model = new ChitsModel();
                model.setTitle(chitsDto.getTitle());
                model.setChitvalue(chitsDto.getChitvalue());
                model.setTotalmonths(chitsDto.getTotalmonths());
                model.setNumberofmembers(chitsDto.getNumberofmembers());
                model.setMonthlysubscription(chitsDto.getMonthlysubscription());
                model.setWeeklysubscription(chitsDto.getWeeklysubscription());
                model.setDailysubscription(chitsDto.getDailysubscription());
                model = this.chitsDao.save(model);
                DividentDto divident = new DividentDto();
                divident.setChitinfo(model);
                divident.setChitid(model.getChitid());
                this.dividentServices.add(divident);
                return response;
            }
            ResponseDto response = new ResponseDto("Error", "Totalmonths is empty", "Test");
            return response;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<ChitsDto> getAll() throws Exception {
        List chits = this.chitsDao.getAll();
        ArrayList<ChitsDto> list = new ArrayList<ChitsDto>();
        chits.stream().forEach(model -> list.add(new ChitsDto(model)));
        return list;
    }

    public ChitsDto getById(Long chitid) throws Exception {
        try {
            ChitsModel chit = (ChitsModel)this.chitsDao.getlistById(chitid).get(0);
            if (chit != null) {
                ChitsDto chitsDto = new ChitsDto();
                chitsDto.setChitid(chit.getChitid());
                chitsDto.setTitle(chit.getTitle());
                chitsDto.setChitvalue(chit.getChitvalue());
                chitsDto.setTotalmonths(chit.getTotalmonths());
                chitsDto.setNumberofmembers(chit.getNumberofmembers());
                chitsDto.setMonthlysubscription(chit.getMonthlysubscription());
                chitsDto.setWeeklysubscription(chit.getWeeklysubscription());
                chitsDto.setDailysubscription(chit.getDailysubscription());
                return chitsDto;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return null;
    }

    public MemberHeaderInfo getmemberheaderinfo(Long chitid) throws Exception {
        try {
            System.out.println("yes");
            MemberHeaderInfo info = new MemberHeaderInfo();
            System.out.println("MemberHeaderInfo");
            ChitGroupModel group = this.chitGroupDao.getById(chitid);
            System.out.println("ChitGroupModel");
            Boolean presentchit = this.chitsDao.existsById(group.getChitid());
            ChitsModel chit = new ChitsModel();
            if (presentchit.booleanValue()) {
                chit = this.chitsDao.getById(group.getChitid());
            }
            List members = this.chitGroupMembersDao.getBygroupIdList(group.getChitgroupid());
            Double chitvalue = Double.parseDouble(chit.getChitvalue());
            info.setChitvalue(chitvalue.toString());
            if (chit != null) {
                int i;
                GroupPaymentRecordModel pay;
                int i2;
                System.out.println("chit");
                info.setChitid(chit.getChitid());
                info.setChitgroupid(group.getChitgroupid());
                info.setGroupnumber(group.getGroupnumber());
                info.setStartdate(group.getStartdate());
                info.setEnddate(group.getEnddate());
                info.setChitname(chit.getTitle());
                List payments = this.paymentsDao.getByGroupId(group.getChitgroupid());
                System.out.println("payments");
                Double payed = 0.0;
                Double pending = 0.0;
                double currpaypending = 0.0;
                double tillmonthpaymenttotal = 0.0;
                Calendar cal = Calendar.getInstance();
                Date date1 = cal.getTime();
                int month = date1.getMonth();
                int year = date1.getYear();
                String MonthYear = ++month + "/" + (year += 1900);
                GroupPaymentRecordModel recodgetmonth = this.groupPaymentRecordDao.recodgetmonth(group.getChitgroupid(), MonthYear);
                List records = new ArrayList();
                if (recodgetmonth != null) {
                    records = this.groupPaymentRecordDao.getBychitgroupidAndMonthYear(group.getChitgroupid(), Long.valueOf(Long.parseLong(recodgetmonth.getDividentmonth()) - 1L));
                    for (i2 = 0; i2 < records.size(); ++i2) {
                        pay = (GroupPaymentRecordModel)records.get(i2);
                        currpaypending += Double.parseDouble(pay.getMonthelypay());
                    }
                }
                info.setCurrentamountpending("" + (currpaypending *= (double)members.size()));
                records = this.groupPaymentRecordDao.getBychitgroupid(group.getChitgroupid());
                for (i2 = 0; i2 < records.size(); ++i2) {
                    pay = (GroupPaymentRecordModel)records.get(i2);
                    tillmonthpaymenttotal += Double.parseDouble(pay.getMonthelypay());
                }
                tillmonthpaymenttotal *= (double)members.size();
                double tillmonthpaymenttotalpayed = 0.0;
                double currentmonthbalance = 0.0;
                for (i = 0; i < records.size(); ++i) {
                    GroupPaymentRecordModel record = (GroupPaymentRecordModel)records.get(i);
                    List currentmonthpayments = this.paymentsDao.findByChitgroupidAndMonthAndYear(group.getChitgroupid(), month, year);
                    for (int j = 0; j < currentmonthpayments.size(); ++j) {
                        PaymentsModel payment = (PaymentsModel)currentmonthpayments.get(j);
                        tillmonthpaymenttotalpayed += Double.parseDouble(payment.getAmountpayed());
                    }
                }
                currentmonthbalance = tillmonthpaymenttotal - tillmonthpaymenttotalpayed;
                info.setPreviousamountpending("" + currentmonthbalance);
                info.setCurrentmonth(month + "/" + year);
                pending = Double.parseDouble(chit.getChitvalue());
                if (payments.size() > 0) {
                    System.out.println("payments");
                    for (i = 0; i < payments.size(); ++i) {
                        PaymentsModel payment = (PaymentsModel)payments.get(i);
                        payed = Double.parseDouble(payment.getAmountpayed()) + payed;
                        pending = pending - payed;
                    }
                }
                info.setAmountpending(pending.toString());
                info.setAmountreceived(payed.toString());
                PaymentDto paymentDto = new PaymentDto();
                paymentDto.setChitgroupid(chitid);
                PaymentHeaderResponse paymentheader = this.paymentServices.getpaymentheaderdetailsByChitGroupId(paymentDto);
                info.setAmountpending(paymentheader.getPending());
                info.setAmountreceived(paymentheader.getReceived());
                info.setPreviousamountpending(paymentheader.getPrevious());
                info.setCurrentamountpending(paymentheader.getTotal());
            }
            return info;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public MemberHeaderInfo getmemberheaderinfowithMonth(Long chitid, String string) throws Exception {
        try {
            System.out.println("yes");
            MemberHeaderInfo info = new MemberHeaderInfo();
            System.out.println("MemberHeaderInfo");
            ChitGroupModel group = this.chitGroupDao.getById(chitid);
            System.out.println("ChitGroupModel");
            Boolean presentchit = this.chitsDao.existsById(group.getChitid());
            ChitsModel chit = new ChitsModel();
            if (presentchit.booleanValue()) {
                chit = this.chitsDao.getById(group.getChitid());
            }
            List members = this.chitGroupMembersDao.getBygroupIdList(group.getChitgroupid());
            Double chitvalue = Double.parseDouble(chit.getChitvalue());
            info.setChitvalue(chitvalue.toString());
            if (chit != null) {
                int i;
                GroupPaymentRecordModel pay;
                int i2;
                System.out.println("chit");
                info.setChitid(chit.getChitid());
                info.setChitgroupid(group.getChitgroupid());
                info.setGroupnumber(group.getGroupnumber());
                info.setStartdate(group.getStartdate());
                info.setEnddate(group.getEnddate());
                info.setChitname(chit.getTitle());
                String receivedmonth = string.substring(0, string.indexOf("/"));
                String receivedyear = string.substring(string.indexOf("/") + 1);
                int month = Integer.parseInt(receivedmonth);
                int year = Integer.parseInt(receivedyear);
                String MonthYear = month + "/" + year;
                List payments = this.paymentsDao.findByChitgroupidAndMonthAndYear(group.getChitgroupid(), month, year);
                System.out.println("payments");
                Double payed = 0.0;
                Double pending = 0.0;
                double currpaypending = 0.0;
                double tillmonthpaymenttotal = 0.0;
                GroupPaymentRecordModel recodgetmonth = this.groupPaymentRecordDao.recodgetmonth(group.getChitgroupid(), MonthYear);
                List records = new ArrayList();
                if (recodgetmonth != null) {
                    records = this.groupPaymentRecordDao.getBychitgroupidAndMonthYear(group.getChitgroupid(), Long.valueOf(Long.parseLong(recodgetmonth.getDividentmonth()) - 1L));
                    for (i2 = 0; i2 < records.size(); ++i2) {
                        pay = (GroupPaymentRecordModel)records.get(i2);
                        currpaypending += Double.parseDouble(pay.getMonthelypay());
                    }
                }
                info.setCurrentamountpending("" + (currpaypending *= (double)members.size()));
                records = this.groupPaymentRecordDao.getBychitgroupid(group.getChitgroupid());
                for (i2 = 0; i2 < records.size(); ++i2) {
                    pay = (GroupPaymentRecordModel)records.get(i2);
                    tillmonthpaymenttotal += Double.parseDouble(pay.getMonthelypay());
                }
                double tillmonthpaymenttotalpayed = 0.0;
                double currentmonthbalance = 0.0;
                System.out.println(tillmonthpaymenttotal *= (double)members.size());
                for (i = 0; i < records.size(); ++i) {
                    GroupPaymentRecordModel record = (GroupPaymentRecordModel)records.get(i);
                    if (month > Integer.parseInt(record.getDividentmonth())) continue;
                    List currentmonthpayments = this.paymentsDao.findByChitgroupidAndMonthAndYear(group.getChitgroupid(), month, year);
                    for (int j = 0; j < currentmonthpayments.size(); ++j) {
                        PaymentsModel payment = (PaymentsModel)currentmonthpayments.get(j);
                        tillmonthpaymenttotalpayed += Double.parseDouble(payment.getAmountpayed());
                    }
                }
                currentmonthbalance = tillmonthpaymenttotal - tillmonthpaymenttotalpayed;
                info.setPreviousamountpending("" + currentmonthbalance);
                info.setCurrentmonth(month + "/" + year);
                pending = Double.parseDouble(chit.getChitvalue());
                if (payments.size() > 0) {
                    System.out.println("payments");
                    for (i = 0; i < payments.size(); ++i) {
                        PaymentsModel payment = (PaymentsModel)payments.get(i);
                        payed = Double.parseDouble(payment.getAmountpayed()) + payed;
                        pending = pending - payed;
                    }
                }
                info.setAmountpending(pending.toString());
                info.setAmountreceived(payed.toString());
                PaymentDto paymentDto = new PaymentDto();
                paymentDto.setChitgroupid(chitid);
                paymentDto.setMonth("" + month);
                paymentDto.setYear("" + year);
                PaymentHeaderResponse paymentheader = this.paymentServices.getpaymentheaderdetailsByMonthAndChitGroupId(paymentDto);
                info.setAmountpending(paymentheader.getPending());
                info.setAmountreceived(paymentheader.getReceived());
                info.setPreviousamountpending(paymentheader.getPrevious());
                info.setCurrentamountpending(paymentheader.getTotal());
            }
            return info;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public ResponseDto edit(ChitsDto chitsDto) throws Exception {
        try {
            if (chitsDto.getChitid() != null) {
                ChitsModel chit = this.chitsDao.getById(chitsDto.getChitid());
                chit.setTitle(chitsDto.getTitle());
                chit.setChitvalue(chitsDto.getChitvalue());
                chit.setTotalmonths(chitsDto.getTotalmonths());
                chit.setNumberofmembers(chitsDto.getNumberofmembers());
                chit.setMonthlysubscription(chitsDto.getMonthlysubscription());
                chit.setWeeklysubscription(chitsDto.getWeeklysubscription());
                chit.setDailysubscription(chitsDto.getDailysubscription());
                chit = this.chitsDao.save(chit);
                ResponseDto response = new ResponseDto("Success", "Chit edit Successfully", "Test");
                return response;
            }
            ResponseDto response = new ResponseDto("Error", "Chit edit failed", "Test");
            return response;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public ResponseDto delete(Long chitid) throws Exception {
        try {
            this.chitsDao.delete(chitid);
            ResponseDto response = new ResponseDto("Success", "Chit deleted Successfully", "Test");
            return response;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

