/*
 * Decompiled with CFR 0.152.
 */
package com.main.Service;

import com.main.Service.EmployeeService;
import com.main.dao.EmployeeDao;
import com.main.dao.UserDao;
import com.main.dto.EmployeeDto;
import com.main.dto.ResponseDto;
import com.main.model.EmployeeModel;
import com.main.model.Role;
import com.main.model.User;
import com.main.response.EmployeeResponse;
import com.main.response.UserResponse;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class EmployeeServiceImpl
implements EmployeeService {
    @Autowired
    PasswordEncoder encoder;
    @Autowired
    EmployeeDao employeeDao;
    @Autowired
    UserDao userDao;

    public ResponseDto register(EmployeeDto employeeDto, String aS) throws Exception {
        try {
            if (employeeDto.getEmail() != null && employeeDto.getPassword() != null) {
                String bearer = aS.substring(aS.indexOf(".") + 1);
                String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
                Base64.Decoder decoder = Base64.getUrlDecoder();
                String token = new String(decoder.decode(bearer1));
                JSONObject jsonObject = new JSONObject(token);
                String userName = jsonObject.getString("sub");
                Boolean us = this.employeeDao.existsByEmail(employeeDto.getEmail());
                Boolean creator = this.userDao.existsByEmail(employeeDto.getEmail());
                if (!creator.booleanValue() && !us.booleanValue()) {
                    EmployeeModel emp = EmployeeModel.builder().firstname(employeeDto.getFirstname()).lastname(employeeDto.getLastname()).email(employeeDto.getEmail()).mobile(employeeDto.getMobile()).createdby(userName).dateofjoining(employeeDto.getDateofjoining()).status(Boolean.valueOf(true)).role(Role.USER).build();
                    this.employeeDao.save(emp);
                    User user = User.builder().firstname(employeeDto.getFirstname()).lastname(employeeDto.getLastname()).email(employeeDto.getEmail()).password(this.encoder.encode((CharSequence)employeeDto.getPassword())).role(Role.USER).build();
                    this.userDao.save(user);
                    ResponseDto response = new ResponseDto("Success", "Employee Created Successfully", "Test");
                    return response;
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        ResponseDto response = new ResponseDto("Error", "Employee Creation Failed", "Test");
        return response;
    }

    public List<EmployeeResponse> getEmployees() {
        List employees = this.employeeDao.findAll();
        ArrayList<EmployeeResponse> list = new ArrayList<EmployeeResponse>();
        employees.stream().forEach(model -> list.add(new EmployeeResponse(model)));
        return list;
    }

    public ResponseDto edit(EmployeeDto employeeDto) throws Exception {
        try {
            EmployeeModel employees = this.employeeDao.findById(employeeDto.getEmployeeid());
            Optional creator = this.userDao.findByEmail(employees.getEmail());
            if (creator == null) {
                ResponseDto response = new ResponseDto("Error", "Employee not found", "Test");
                return response;
            }
            if (employeeDto.getFirstname() != null) {
                employees.setFirstname(employeeDto.getFirstname());
                ((User)creator.get()).setFirstname(employeeDto.getFirstname());
            }
            if (employeeDto.getLastname() != null) {
                employees.setLastname(employeeDto.getLastname());
                ((User)creator.get()).setLastname(employeeDto.getLastname());
            }
            if (employeeDto.getPassword() != null) {
                ((User)creator.get()).setPassword(this.encoder.encode((CharSequence)employeeDto.getPassword()));
            }
            if (employeeDto.getEmail() != null) {
                employees.setEmail(employeeDto.getEmail());
                ((User)creator.get()).setEmail(employeeDto.getEmail());
            }
            if (employeeDto.getMobile() != null) {
                employees.setMobile(employeeDto.getMobile());
                ((User)creator.get()).setMobile(employeeDto.getMobile());
            }
            if (employeeDto.getDateofjoining() != null) {
                employees.setDateofjoining(employeeDto.getDateofjoining());
            }
            if (employeeDto.getStatus() != null) {
                employees.setStatus(employeeDto.getStatus());
            }
            this.userDao.save((User)creator.get());
            this.employeeDao.save(employees);
            ResponseDto response = new ResponseDto("Success", "Employee Edited Successfully", "Test");
            return response;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public ResponseDto delete(Long employeeid) {
        Optional<EmployeeModel> employee = Optional.of(this.employeeDao.findById(employeeid));
        System.out.println(employee.get().getEmail());
        Optional user = this.userDao.findByEmail(employee.get().getEmail());
        System.out.println(((User)user.get()).getId());
        if (employee.get().getEmployeeid() != null) {
            this.employeeDao.delete(employeeid);
            this.userDao.delete(((User)user.get()).getId());
            ResponseDto response = new ResponseDto("Success", "Employee Deleted Successfully", "Test");
            return response;
        }
        ResponseDto response = new ResponseDto("Error", "Employee id not present", "Test");
        return response;
    }

    public UserResponse getDetails(String aS) {
        String bearer = aS.substring(aS.indexOf(".") + 1);
        String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearer1));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        UserResponse res = new UserResponse();
        res.setEmail(((User)creator.get()).getEmail());
        res.setFirstname(((User)creator.get()).getFirstname());
        res.setLastname(((User)creator.get()).getLastname());
        res.setId(((User)creator.get()).getId());
        res.setMobile(((User)creator.get()).getMobile());
        res.setRole(((User)creator.get()).getRole());
        return res;
    }
}

