/*
 * Decompiled with CFR 0.152.
 */
package com.main.controller;

import com.main.Service.ChitsService;
import com.main.dto.ChitsDto;
import com.main.dto.MemberHeaderInfo;
import com.main.dto.ResponseDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/chits"})
public class ChitsController {
    @Autowired
    ChitsService chitsService;

    @PostMapping(value={"/add"})
    public ResponseDto add(@RequestBody ChitsDto chitsDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.chitsService.add(chitsDto);
    }

    @PostMapping(value={"/get"})
    public List<ChitsDto> getAll(@RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.chitsService.getAll();
    }

    @PostMapping(value={"/getbyid"})
    public ChitsDto getById(@RequestBody ChitsDto chitsDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.chitsService.getById(chitsDto.getChitid());
    }

    @PostMapping(value={"/getmemberheaderinfo"})
    public MemberHeaderInfo getmemberheaderinfo(@RequestBody ChitsDto chitsDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        if (chitsDto.getMonth() == null) {
            return this.chitsService.getmemberheaderinfo(chitsDto.getChitid());
        }
        return this.chitsService.getmemberheaderinfowithMonth(chitsDto.getChitid(), chitsDto.getMonth());
    }

    @PostMapping(value={"/edit"})
    public ResponseDto edit(@RequestBody ChitsDto chitsDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.chitsService.edit(chitsDto);
    }

    @PostMapping(value={"/delete"})
    public ResponseDto delete(@RequestBody ChitsDto chitsDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.chitsService.delete(chitsDto.getChitid());
    }
}

