/*
 * Decompiled with CFR 0.152.
 */
package com.main.controller;

import com.main.Service.AuthenticationService;
import com.main.Service.EmployeeService;
import com.main.request.RegisterRequest;
import com.main.response.AuthenticationResponse;
import com.main.response.UserResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/sign"})
public class LoginAndRegistrationController {
    private final AuthenticationService authenticationService;
    @Autowired
    EmployeeService employeeService;

    @PostMapping(value={"/register"})
    public ResponseEntity<AuthenticationResponse> register(@RequestBody RegisterRequest request, @RequestHeader(value="Authorization") String authenticationHeader) {
        return ResponseEntity.ok((Object)this.authenticationService.register(request));
    }

    @PostMapping(value={"/authenticate"})
    public ResponseEntity<AuthenticationResponse> authenticate(@RequestBody RegisterRequest request) {
        return ResponseEntity.ok((Object)this.authenticationService.authenticate(request));
    }

    @GetMapping(value={"/getuserdetails"})
    public UserResponse getDetails(@RequestHeader(value="Authorization") String AS) {
        return this.employeeService.getDetails(AS);
    }

    public LoginAndRegistrationController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}

