/*
 * Decompiled with CFR 0.152.
 */
package com.main.controller;

import com.main.Service.MemberService;
import com.main.dto.ChitGroupMembersDto;
import com.main.dto.MemberDto;
import com.main.dto.PrimaryMemberDto;
import com.main.dto.ResponseDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1/member"})
public class MemberController {
    @Autowired
    MemberService memberService;

    @PostMapping(value={"/add"})
    public ResponseDto add(@RequestBody MemberDto memberDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.addMember(memberDto);
    }

    @PostMapping(value={"/file"})
    public ResponseDto file(@RequestPart(value="file") MultipartFile file, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.file(file);
    }

    @PostMapping(value={"/filedelete"})
    public ResponseDto filedelete(@RequestParam(value="fileid") Long file, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.filedelete(file);
    }

    @PostMapping(value={"/get"})
    public List<MemberDto> get(@RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.getMember();
    }

    @PostMapping(value={"/getforgroup"})
    public List<MemberDto> getforgroup(@RequestBody MemberDto memberDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.getMemberforgroup(memberDto.getChitgroupid());
    }

    @PostMapping(value={"/getprimary"})
    public List<PrimaryMemberDto> getprimary(@RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.getprimary();
    }

    @PostMapping(value={"/getbyid"})
    public MemberDto get(@RequestBody MemberDto memberDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.getMemberByID(memberDto.getMemberid());
    }

    @PostMapping(value={"/getermembers"})
    public List<ChitGroupMembersDto> getErMembers(@RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.getErMembers();
    }

    @PostMapping(value={"/edit"})
    public ResponseDto edit(@RequestBody MemberDto memberDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.editMemberByID(memberDto);
    }

    @PostMapping(value={"/delete"})
    public ResponseDto delete(@RequestBody MemberDto memberDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.memberService.deleteMemberByID(memberDto.getMemberid());
    }
}

