/*
 * Decompiled with CFR 0.152.
 */
package com.main.controller;

import com.main.Service.PaymentServices;
import com.main.dto.PaymentDto;
import com.main.dto.PaymentTabsDto;
import com.main.dto.ResponseDto;
import com.main.response.MemberPaymentDetails;
import com.main.response.PaymentHeaderResponse;
import com.main.response.PaymentMonthYear;
import com.main.response.RepaymentResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/payment"})
public class PaymentsController {
    @Autowired
    PaymentServices paymentServices;

    @PostMapping(value={"/add"})
    public ResponseDto add(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.AddPayment1(paymentDto);
    }

    @PostMapping(value={"/get"})
    public List<PaymentDto> getAll(@RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.getAll();
    }

    @PostMapping(value={"/getbymonth"})
    public List<PaymentTabsDto> getbymonth(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        if (paymentDto.getMonth() != null && paymentDto.getYear() != null && paymentDto.getChitgroupid() != null) {
            return this.paymentServices.getByMonthAndChitgroupid(paymentDto);
        }
        if (paymentDto.getChitgroupid() != null) {
            return this.paymentServices.getByMonthByChitGroupId(paymentDto);
        }
        if (paymentDto.getMonth() != null && paymentDto.getYear() != null) {
            return this.paymentServices.getByMonth(paymentDto);
        }
        return this.paymentServices.getByMonthAll(paymentDto);
    }

    @PostMapping(value={"/getbyid"})
    public PaymentDto getById(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.getById(paymentDto.getPaymentid());
    }

    @PostMapping(value={"/getbychitgroupmemberid"})
    public List<PaymentDto> getbychitgroupmemberid(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.getbychitgroupmemberid(paymentDto.getChitgroupmembersid());
    }

    @PostMapping(value={"/getmonthforpayment"})
    public List<PaymentMonthYear> getmonthforpayment(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        if (paymentDto.getChitgroupmembersid() != null) {
            return this.paymentServices.getmonthforpayment(paymentDto.getChitgroupmembersid());
        }
        return this.paymentServices.getmonthforpaymentbygroupid(paymentDto.getChitgroupid());
    }

    @PostMapping(value={"/getmemberpaymentdetails"})
    public MemberPaymentDetails getmemberpaymentdetails(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        if (paymentDto.getMonth() == null) {
            return this.paymentServices.getmemberpaymentdetails(paymentDto.getChitgroupmembersid());
        }
        return this.paymentServices.getmemberpaymentdetailswithmonth(paymentDto.getChitgroupmembersid(), paymentDto.getMonth());
    }

    @PostMapping(value={"/getpaymentheaderdetails"})
    public PaymentHeaderResponse getpaymentheaderdetails(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        if (paymentDto.getMonth() != null && paymentDto.getChitgroupid() != null) {
            return this.paymentServices.getpaymentheaderdetailsByMonthAndChitGroupId(paymentDto);
        }
        if (paymentDto.getChitgroupmembersid() != null && paymentDto.getMonth() != null) {
            return this.paymentServices.getpaymentheaderdetailsByMonthAndChitgroupmembersid(paymentDto);
        }
        if (paymentDto.getChitgroupmembersid() != null) {
            return this.paymentServices.getpaymentheaderdetailsByChitgroupmembersid(paymentDto);
        }
        if (paymentDto.getChitgroupid() != null) {
            return this.paymentServices.getpaymentheaderdetailsByChitGroupId(paymentDto);
        }
        if (paymentDto.getMonth() != null) {
            return this.paymentServices.getpaymentheaderdetailsByMonth(paymentDto);
        }
        return this.paymentServices.getpaymentheaderdetails(paymentDto);
    }

    @PostMapping(value={"/edit"})
    public ResponseDto edit(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.edit(paymentDto);
    }

    @PostMapping(value={"/delete"})
    public ResponseDto delete(@RequestBody PaymentDto paymentDto, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.delete(paymentDto);
    }

    @PostMapping(value={"/getrepayment"})
    public List<RepaymentResponse> getrepayment(@RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.getrepayment();
    }

    @PostMapping(value={"/repay"})
    public ResponseDto repay(@RequestBody RepaymentResponse repaymentResponse, @RequestHeader(value="Authorization") String authenticationHeader) throws Exception {
        return this.paymentServices.repay(repaymentResponse);
    }
}

