/*
 * Decompiled with CFR 0.152.
 */
package com.main.model;

import com.main.model.Role;
import com.main.model.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="_users")
public class User
implements UserDetails {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private Long id;
    private String firstname;
    private String lastname;
    private String password;
    private String email;
    private String description;
    private Long mobile;
    @Enumerated(value=EnumType.STRING)
    private Role role;
    @LastModifiedDate
    @Column(name="lastmodifieddate")
    private Date lastModifiedDate;
    @Column(name="createdate")
    @CreationTimestamp
    private Date createDate;

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return List.of(new SimpleGrantedAuthority(this.role.name()));
    }

    public String getUsername() {
        return this.email;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getPassword() {
        return this.password;
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getMobile() {
        return this.mobile;
    }

    public Role getRole() {
        return this.role;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$mobile = this.getMobile();
        Long other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !((Object)this$mobile).equals(other$mobile)) {
            return false;
        }
        String this$firstname = this.getFirstname();
        String other$firstname = other.getFirstname();
        if (this$firstname == null ? other$firstname != null : !this$firstname.equals(other$firstname)) {
            return false;
        }
        String this$lastname = this.getLastname();
        String other$lastname = other.getLastname();
        if (this$lastname == null ? other$lastname != null : !this$lastname.equals(other$lastname)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Date this$lastModifiedDate = this.getLastModifiedDate();
        Date other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        return !(this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : ((Object)$mobile).hashCode());
        String $firstname = this.getFirstname();
        result = result * 59 + ($firstname == null ? 43 : $firstname.hashCode());
        String $lastname = this.getLastname();
        result = result * 59 + ($lastname == null ? 43 : $lastname.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Date $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        return result;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", firstname=" + this.getFirstname() + ", lastname=" + this.getLastname() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", description=" + this.getDescription() + ", mobile=" + this.getMobile() + ", role=" + this.getRole() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", createDate=" + this.getCreateDate() + ")";
    }

    public User(Long id, String firstname, String lastname, String password, String email, String description, Long mobile, Role role, Date lastModifiedDate, Date createDate) {
        this.id = id;
        this.firstname = firstname;
        this.lastname = lastname;
        this.password = password;
        this.email = email;
        this.description = description;
        this.mobile = mobile;
        this.role = role;
        this.lastModifiedDate = lastModifiedDate;
        this.createDate = createDate;
    }

    public User() {
    }
}

